#!/bin/sh

TP_MIXEDFORM_RESULT_NULL="DTAS[TUI]@{NULL}"
TP_MIXEDFORM_RESULT_DATA=""

TP_MIXEDFORM_RESULT_OK="DTAS[TUI]@{OK}"
TP_MIXEDFORM_RESULT_CANCEL="DTAS[TUI]@{CANCEL}"
TP_MIXEDFORM_RESULT_ERROR="DTAS[TUI]@{ERROR}"
TP_MIXEDFORM_RESULT_CODE=""

TP_MIXEDFORM_RESULT_MSG=""

tp_mixedform() {
	#debug_print "${0}" "${LINENO}" 'in function "tp_mixedform"'

	local title="${1}"
	local text="${2}"
	local label_ok="${3}"
	local label_cancel="${4}"
	local mixedform_data="${5}"
	local mixedform_height="${6:-0}"
	
	exec 3>&1
	local ret=`sh -c "dialog \
		--backtitle    \"${CONS_BACK_TITLE}\" \
		--title        \"${title}\" \
		--ok-label     \"${label_ok}\" \
		--cancel-label \"${label_cancel}\" \
		--insecure \
		--mixedform    \"${text}\" \"${CONS_BOX_HEIGHT}\" \"${CONS_BOX_WIDTH}\" ${mixedform_height} \
		${mixedform_data} \
		2>&1 1>&3"; \
		case "${?}" in \
			1|255) echo "${TP_MIXEDFORM_RESULT_CANCEL}" ;; \
		esac`
	exec 3>&-
	
    case "${ret}" in
        # press CANCEL or ESC
        "${TP_MIXEDFORM_RESULT_CANCEL}") 
            TP_MIXEDFORM_RESULT_CODE="${TP_MIXEDFORM_RESULT_CANCEL}"
            TP_MIXEDFORM_RESULT_DATA="${TP_MIXEDFORM_RESULT_NULL}"
            TP_MIXEDFORM_RESULT_MSG=""
            ;;
        *)
			TP_MIXEDFORM_RESULT_CODE="${TP_MIXEDFORM_RESULT_OK}"
			TP_MIXEDFORM_RESULT_DATA="${ret}"
			TP_MIXEDFORM_RESULT_MSG=""
			;;
    esac
}
